// sp_control
// cntrl thinks
#include "g_local.h"
int ctrlmdl[3];

void Power_Overlay(void)
{
	char str[512], 
		mk0[10], mk1[10], mk2[10],
		rgb0[4], rgb1[4], rgb2[4];

	if (CTFGame.markers[0] && CTFGame.markers[1] && CTFGame.markers[2])
	{
		if (ctrlmdl[0] == CTFGame.markers[0]->s.modelindex)
		{
			strcpy(mk0, "markx");
			strcpy(rgb0, "888");

		}
		else if (ctrlmdl[1] == CTFGame.markers[0]->s.modelindex)
		{
			strcpy(mk0, "markb");
			strcpy(rgb0, "118");
		}
		else if (ctrlmdl[2] == CTFGame.markers[0]->s.modelindex)
		{
			strcpy(mk0, "markr");
			strcpy(rgb0, "811");
		}

		if (ctrlmdl[0] == CTFGame.markers[1]->s.modelindex)
		{
			strcpy(mk1, "markx");
			strcpy(rgb1, "888");

		}
		else if (ctrlmdl[1] == CTFGame.markers[1]->s.modelindex)
		{
			strcpy(mk1, "markb");
			strcpy(rgb1, "118");
		}
		else if (ctrlmdl[2] == CTFGame.markers[1]->s.modelindex)
		{
			strcpy(mk1, "markr");
			strcpy(rgb1, "811");
		}

		if (ctrlmdl[0] == CTFGame.markers[2]->s.modelindex)
		{
			strcpy(mk2, "markx");
			strcpy(rgb2, "888");
		}
		else if (ctrlmdl[1] == CTFGame.markers[2]->s.modelindex)
		{
			strcpy(mk2, "markb");
			strcpy(rgb2, "118");
		}
		else if (ctrlmdl[2] == CTFGame.markers[2]->s.modelindex)
		{
			strcpy(mk2, "markr");
			strcpy(rgb2, "811");
		}

		sprintf(str, "xl 10 yt 30 dmstr %s \"%s\" "
					 "yt 110 dmstr %s \"%s\" "
					 "yt 190 dmstr %s \"%s\" "
					 "xl 20 yt 50 picn %s "
					 "xl 20 yt 130 picn %s "
					 "xl 20 yt 210 picn %s ",
					 rgb0, CTFGame.markers[0]->name,
					 rgb1, CTFGame.markers[1]->name,
					 rgb2, CTFGame.markers[2]->name,
					 mk0, mk1, mk2);

	//	gi.dprintf("%s\n", str);
		gi.WriteByte (svc_layout);
		gi.WriteString (str);	
	}
}

void ControlThink (edict_t *self)
{
	// What about cash spawning?
	// Give score
	if (level.intermissiontime)
		return;

	if(self->CollectDelay > 0)
		self->CollectDelay--;

	if ( self->s.modelindex == ctrlmdl[1] )
	{
		CTFGame.teamscore[0]++;
		if(CTFGame.teamscore[0] > 9999)
			CTFGame.teamscore[0] = 0;

//		if (developer->value)
//			gi.dprintf("add score team 1: %d from marker %d\n", power.teamscore[1], self->count);
	}

	if ( self->s.modelindex == ctrlmdl[2] )
	{
		CTFGame.teamscore[1]++;
		if(CTFGame.teamscore[1] > 9999)
			CTFGame.teamscore[1] = 0;
//		if (developer->value)
//			gi.dprintf("add score team 2: %d from marker %d\n", power.teamscore[2], self->count);
	}

	self->nextthink = level.time + CONTROL_THINK_TIME;
}

void control_point_touch (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	if(self->CollectDelay > 0)
		return;

	if (other->leader)
		other = other->leader;

	if (!other->client)
		return;

	if (self->s.modelindex == ctrlmdl[other->client->pers.team])
		return;// already owned

	gi.bprintf(PRINT_HIGH, "%s captured %s.\n", team_names[other->client->pers.team], self->name);
//Give a bonus frag for capturing the point
	other->client->resp.score += POWER_POINTS_CONTROL_CAPTURE_BONUS;
//Make the team score flash for a while
	CTFGame.capture_time[other->client->pers.team - 1] = level.time + CTF_CAPTURE_FLASH_TIME;

//	gi.dprintf("TODO: give score/cash to %s\n", other->client->pers.netname);
	self->CollectDelay = CONTROL_CAPTURE_DELAY;
//Power 2 does not award cash for capture
//	other->client->pers.currentcash += POWER_POINTS_CAPTURE_CONTROL;

//	gi.bprintf(PRINT_MEDIUM, "switched %s\n", other->client->pers.netname);
	// give score if it changed team
	self->s.modelindex = ctrlmdl[other->client->pers.team];

	self->nextthink = level.time + CONTROL_THINK_TIME;
	gi.linkentity (self);

	Power_Overlay();
	gi.multicast (self->s.origin, MULTICAST_ALL);

}

void SP_ControlPoint (edict_t *self)
{
//	gi.dprintf("Control Spawned\n");

	if(strcmp(level.mapname, "power_docks") == 0)
	{
		if(strncmp(self->name, "Center of the map", 17) == 0)
			strcpy(self->name, "Tunnel");
		if(strncmp(self->name, "In building", 11) == 0)
			strcpy(self->name, "Wood Room");
		if(strncmp(self->name, "In warehouse", 12) == 0)
			strcpy(self->name, "Warehouse Office");
	}
	else
		if(strcmp(level.mapname, "power_iraq") == 0)
		{
			if(strncmp(self->name, "Center of the map", 17) == 0)
				strcpy(self->name, "Central Fort");
			if(strcmp(self->name, "Behind Tank") == 0)
				strcpy(self->name, "Tank");
			if(strncmp(self->name, "in building", 11) == 0)
				strcpy(self->name, "Command Centre");
		}

	
	if (CTFGame.num_control_points == 0)
	{
		// precache
		ctrlmdl[0]=gi.modelindex ("models/controls/m3.md2");
		ctrlmdl[1]=gi.modelindex ("models/controls/m2.md2");
		ctrlmdl[2]=gi.modelindex ("models/controls/m1.md2");
	}
	else if (CTFGame.num_control_points >= MAX_CONTROL_POINTS)
	{
		if (developer->value)
			gi.dprintf("DEBUG: Cant add any more markers\n");
		return;
	}

	self->model = "models/controls/m3.md2";
	self->s.effects = EF_ROTATE;
	VectorSet (self->mins, -16, -16, -24);// As big as player
	VectorSet (self->maxs, 16, 16, 48);
	self->s.renderfx = RF_GLOW;
	self->s.modelindex = ctrlmdl[0];
	self->touch = control_point_touch;
	self->solid = SOLID_TRIGGER;
	self->think = ControlThink;
	self->count = CTFGame.num_control_points;
	self->CollectDelay = 0;
	self->nextthink = level.time + CONTROL_THINK_TIME;

/*	if (!self->name)
	{
		self->name = malloc(30);
		sprintf(self->name, "Marker %d", power.num_control_points);
	}
*/
	CTFGame.markers[CTFGame.num_control_points++] = self;
	
	gi.linkentity (self);
//	KillBox(self);
}

extern void ED_CallSpawn (edict_t *ent);
void Cmd_testcontrol_f (edict_t *ent)
{
	edict_t	*control;	
	vec3_t	forward, right, offset;
	trace_t	trace;

	control = G_Spawn();
	control->think = ED_CallSpawn;//SP_ControlPoint;
	control->nextthink = level.time + 1;
	strcpy(control->classname, "power_control_point");

	AngleVectors (ent->client->v_angle, forward, right, NULL);
	VectorSet(offset, 24, 0, -16);
	G_ProjectSource (ent->s.origin, offset, forward, right, control->s.origin);
	trace = gi.trace (ent->s.origin, control->mins, control->maxs,
		control->s.origin, ent, control->clipmask);
	VectorCopy (trace.endpos, control->s.origin);

	control->s.origin[2]+=30;

	gi.linkentity (control);
}

void PowerControlPoints(void)
{
	char		file_name[256];
	char		name[64];
	cvar_t		*game_dir;
	FILE *fp;
	game_dir = gi.cvar ("game", "", 0);	

	return ;
#ifdef UNIX
	sprintf(file_name, "./%s/ents/%s.markers", game_dir->string, level.mapname); 
#else
	sprintf(file_name, ".\\%s\\ents\\%s.markers", game_dir->string, level.mapname);
#endif

	if (fp = fopen(file_name, "r")) 
	{
		int i;
		for (i = 0; i < MAX_CONTROL_POINTS; i++)
		{
			vec3_t pos;
//			char *ptr;
			fgets(name, 64, fp);
		//	strtok(
			//fscanf(fp, "%s %f %f %f\n", name, &pos[0], &pos[1], &pos[2]);
			gi.dprintf("%s %f %f %f\n", name, pos[0], pos[1], pos[2]);
		}
		fclose(fp);
	}
}